/*	******************************************************************************************************************
 *	For automated browser tests (eg Selenium), we need to REALLY know when:
 *		a) Page has loaded (for Browser.GoTo)
 *		b) Request to server was sent, response was received, and everything has been applied, and all fadeouts and other animations
 *			are done. (for Click() or InputText() on search box)
 *
 *	This is how we do it.
 *	When you are starting activity, do the 
 	MA.baTracker.startingActivity();
 	When you are don, do the
    MA.baTracker.finishedActivity();
    
 *	There is a DOM element with the html ID of MA.baTracker.HTML_ID: "__baTrackerEl__"
 *	This is a INPUT TYPE=HIDDEN that has a value that increases every time that the list of pending activities becomes empty.
 *	So now from Selenium, when you submit a request (e.g. click), you wait for this value to change. When it does, you know that the page has responded
 *  and is ready to continue.
 */

if(typeof MA === "undefined")
{
	var MA = {};
}

/*
 *	Browser activity tracker. 
 */

MA.baTracker = 
{
	HTML_ID: "__baTrackerEl__",
	INITIAL_VALUE: "",
	domEl: null,
	domElIsVisible: false,
	
	activities: [],
	numberOfFinishedActivities: 0,

	startingActivity: function(name)
	{
//		debugger;
		
		try
		{
			this.activities.push({
				name: name
			});
			
			if(name)
			{
				this.log("*** Starting activity [" + name + "] stk=" + this.activities.length);
			}
		}
		catch(e)
		{
			this.err(e);
		}
	},
	
	finishedActivity: function(x)
	{
		try
		{
			var a = this.activities.pop();

			this.log("*** Finished activity stk=" + this.activities.length + " name=" + x);

			if(this.activities.length == 0)
			{
				this.numberOfFinishedActivities++;
				
				if(this.domEl === null)
				{
					this.log("Initialize dom");
					this.initialize(this.numberOfFinishedActivities);
				}
				else
				{
					this.log("Change dom");
					this.domEl.value = "" + this.numberOfFinishedActivities;
				}

				this.log("*** REQ FINISHED: " + this.numberOfFinishedActivities);
			}
		}
		catch(e)
		{
			this.err(e);
		}
	},

	log: function(s)
	{
		if(typeof MA_JSLog === "function")
		{
			MA_JSLog(s);
		}
	},
	
	err: function(error)
	{
		try
		{
			if(window.console && window.console.log)
			{
				if(error.stack){
					var stack = 'ERROR STACK TRACE: ' + error.stack.replace(/^[^\(]+?[\n$]/gm, '')
	      			.replace(/^\s+at\s+/gm, '')
	      			.replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@')
	      			.split('\n');
	  				console.log(stack);
  				}
  				
  				console.log(error);
//				window.console.log(s);
			}
		}
		catch(e)
		{
		}
	},
	
	initialize: function(n)
	{
		try
		{
			if(this.domEl === null)
			{
				var t = document.createElement("input");
	
				if(this.domElIsVisible)
				{
					t.setAttribute("type", "text");
					t.setAttribute("id", this.HTML_ID);
					t.setAttribute("name", this.HTML_ID);
					t.setAttribute("value", "" + n);
					t.style.position = "absolute";
					t.style.top = "0";
					t.style.left = "0";
					t.style.width = "50px";
					t.style.background = "yellow";
					t.style.zIndex = "2000";
				}
				else
				{
					t.setAttribute("id", this.HTML_ID);
					t.setAttribute("type", "hidden");
					t.setAttribute("name", this.HTML_ID);
					t.setAttribute("value", "" + n);
				}
	
				document.body.appendChild(t);
				
				this.domEl = t;
			}
			else
			{
				this.domEl.value = "" + n;
			}
		}
		catch(e)
		{
			this.err(e);
		}
	}
};

/*	******************************************************************************************************************
 * 
 */
