from datetime import datetime

import jdatetime


def get_unique_items(items_list):
    list_of_unique_items = []

    unique_items = set(items_list)

    for item in unique_items:
        item = item.strip()
        list_of_unique_items.append(item)

    return list_of_unique_items


def reading_test_files():
    all_d_files = []
    all_date_times = []

    for index in range(1, 11):
        with open(f"./files/d{index}.txt", encoding="utf-8", errors='ignore') as d_file:
            lines = d_file.readlines()

            all_date_times.append(lines[0].strip()[:-1])
            del lines[0]
            data = ""
            for line in lines:
                data += line.replace('\n', ' ')

            all_d_files.append(data)

    with open("./files/s.txt", encoding="utf-8", errors='ignore') as s_file, \
            open("./files/t.txt", encoding="utf-8", errors='ignore') as t_file:
        lines = s_file.readlines()
        all_date_times.append(lines[0].strip()[:-1])
        del lines[0]
        string_s_file = ""
        for line in lines:
            string_s_file += line.replace('\n', ' ')

        lines = t_file.readlines()
        all_date_times.append(lines[0].strip()[:-1])
        del lines[0]
        string_t_file = ""
        for line in lines:
            string_t_file += line.replace('\n', ' ')

    return string_s_file, string_t_file, all_d_files, all_date_times


def save_value_in_file(filename, value: list):
    with open(f'{filename}.txt', 'w') as f:
        for item in value:
            f.write("%s\n" % item)


def convert_gregorian_to_jalali(datetime_list):
    jalali_datetime_list = []
    for item in datetime_list:
        standard_date = datetime.strptime(item, '%d-%b-%Y')

        jalali_date = jdatetime.date.fromgregorian(
            day=standard_date.day, month=standard_date.month, year=standard_date.year)

        jalali_datetime_list.append(jalali_date.strftime('%d-%b-%Y'))

    return jalali_datetime_list
