from datetime import datetime

from functions.call_redundancy import call_redundancy
from functions.similarity import similarity
import matplotlib.pyplot as plt
from utils import reading_test_files, convert_gregorian_to_jalali  # new
from functions.call_chain import call_chain

if __name__ == '__main__':

    # READING ALL FILES AND GET ARTICLE LIST AND DATETIME ##########

    s, t, article_list, date_time_list = reading_test_files()

    # ##########################

    num_articles = 10
    chain = ["s", "t", "", "", "", "", "", "", ""]
    article = [s, t, "", "", "", "", "", "", ""]
    count = 2

    chain, article = call_chain(s, t, article_list, num_articles, chain, article, count)

    alpha = 500
    new_article1 = [s, t]
    new_chain1 = ["s", "t"]

    for index in range(2, len(chain)):

        similar_s_t = similarity(s, t)

        similar_t = similarity(article[index], t)

        similar_s = similarity(s, article[index])

        if similar_s_t > (similar_t + alpha) or similar_s_t > (similar_s + alpha):
            pass
        else:
            new_article1.append(article[index])
            new_chain1.append(chain[index])

    minimum = 10000000
    maximum = -1

    for index, item in enumerate(date_time_list):
        standard_date = datetime.strptime(item, '%d-%b-%Y')
        date_number = standard_date.toordinal() + 366
        if date_number > maximum:
            maximum = date_number
        if date_number < minimum:
            minimum = date_number

    num_chains = 4
    divide_date = (maximum - minimum) / num_chains

    chain_set = []
    call_redundancy_score = [call_redundancy(new_chain1, chain_set)]
    chain_set = ["", "", "", ""]

    for index, item in enumerate(date_time_list):

        standard_date = datetime.strptime(item, '%d-%b-%Y')
        date_number = standard_date.toordinal() + 366

        if index < num_articles:
            for index2 in range(num_chains):
                if date_number >= (minimum + (index2 * divide_date)):
                    if date_number <= (minimum + ((index2 + 1) * divide_date)):

                        if "d" + str(index + 1) in new_chain1:
                            chain_set[index2] = "d" + str(index + 1)
        else:
            for index2 in range(num_chains):

                if date_number >= (minimum + (index2 * divide_date)):
                    if date_number <= (minimum + ((index2 + 1) * divide_date)):

                        if (index+1) == (num_articles+1):
                            chain_set[index2] = "s"
                        else:
                            chain_set[index2] = "t"

    final_chain = []
    for item in chain_set:
        if not item == '':
            final_chain.append(item)

    call_redundancy_score.append(call_redundancy(new_chain1, final_chain))

    category = ['No pruning', 'PR']

    fig = plt.figure(1, figsize=(15, 10))
    plt.bar(category, call_redundancy_score, width=0.4)
    plt.xlabel('Chain of Paper')
    plt.ylabel('Coherence Score')
    plt.title('Redundancy Score')

    plt.show()
