from functions.similarity import similarity
from functions.similarity_prune import similarity_prune
from functions.similarity_prune_very import similarity_prune_very
import matplotlib.pyplot as plt

from utils import reading_test_files, convert_gregorian_to_jalali  # new
from functions.call_chain import call_chain
from functions.call_coherence import call_coherence

if __name__ == '__main__':

    # READING ALL FILES AND GET ARTICLE LIST AND DATETIME ##########

    s, t, article_list, date_time_list = reading_test_files()

    # ##########################

    num_articles = 10
    chain = ["s", "t", "", "", "", "", "", "", ""]
    article = [s, t, "", "", "", "", "", "", ""]
    count = 2

    chain, article = call_chain(s, t, article_list, num_articles, chain, article, count)

    alpha = 500
    new_article1 = [s, t]
    new_chain1 = ["s", "t"]

    for index in range(2, len(chain)):

        similar_s_t = similarity(s, t)

        similar_t = similarity(article[index], t)

        similar_s = similarity(s, article[index])

        if similar_s_t > (similar_t + alpha) or similar_s_t > (similar_s + alpha):
            pass
        else:
            new_article1.append(article[index])
            new_chain1.append(chain[index])

    prune = 0
    call_coherence_score = [call_coherence(prune, new_chain1, new_article1, s, t)]
    new_article2 = [s, t]
    new_chain2 = ["s", "t"]

    for index in range(2, len(new_chain1)):

        similar_s_t = similarity_prune(s, t)

        similar_t = similarity_prune(new_article1[index], t)

        similar_s = similarity_prune(s, new_article1[index])

        if similar_s_t > (similar_t + alpha) or similar_s_t > (similar_s + alpha):
            pass
        else:
            new_article2.append(new_article1[index])
            new_chain2.append(new_chain1[index])

    prune = 1
    call_coherence_score.append(call_coherence(prune, new_chain2, new_article2, s, t))
    new_article3 = [s, t]
    new_chain3 = ["s", "t"]

    for index in range(2, len(new_chain2)):

        similar_s_t = similarity_prune_very(s, t)

        similar_t = similarity_prune_very(new_article2[index], t)

        similar_s = similarity_prune_very(s, new_article2[index])

        if similar_s_t > (similar_t + alpha) or similar_s_t > (similar_s + alpha):
            pass
        else:
            new_article3.append(new_article2[index])
            new_chain3.append(new_chain2[index])

    prune = 2
    call_coherence_score.append(call_coherence(prune, new_chain3, new_article3, s, t))

    # ###########################
    category = ['No pruning', 'PLR Medium pruning', 'PLR High pruning']

    fig = plt.figure(figsize=(15, 10))

    plt.bar(category, call_coherence_score, color='maroon', width=0.4)

    plt.xlabel("'Chain of Paper")
    plt.ylabel("Coherence Score")
    plt.title("Performance of PLR")
    plt.show()
