from functions.similarity_prune import similarity_prune
from utils import reading_test_files, convert_gregorian_to_jalali  # new
from functions.call_chain import call_chain
from datetime import datetime
from sympy import N

if __name__ == '__main__':

    # READING ALL FILES AND GET ARTICLE LIST AND DATETIME ##########

    s, t, article_list, date_time_list = reading_test_files()

    # ##########################

    num_articles = 10
    chain = ["s", "t", "", "", "", "", "", "", ""]
    article = [s, t, "", "", "", "", "", "", ""]
    count = 2

    chain, article = call_chain(s, t, article_list, num_articles, chain, article, count)

    alpha = 500
    new_article = [s, t]
    new_chain = ["s", "t"]

    # num_chain = len(chain)

    for index in range(2, len(chain)):

        similar_s_t = similarity_prune(s, t)

        similar_t = similarity_prune(article[index], t)

        similar_s = similarity_prune(s, article[index])

        if similar_s_t > (similar_t + alpha) or (similar_s_t > similar_s + alpha):
            pass
        else:

            new_article.append(article[index])
            new_chain.append(chain[index])

    minimum = 10000000
    maximum = -1

    for index, item in enumerate(date_time_list):

        standard_date = datetime.strptime(item, '%d-%b-%Y')
        date_number = standard_date.toordinal() + 366
        if date_number > maximum:
            maximum = date_number
        if date_number < minimum:
            minimum = date_number

    num_chains = 4
    divide_date = (maximum - minimum) / num_chains
    chain_set = ["", "", "", ""]

    for index, item in enumerate(date_time_list):

        standard_date = datetime.strptime(item, '%d-%b-%Y')
        date_number = standard_date.toordinal() + 366

        if index < num_articles:
            for index2 in range(num_chains):
                if date_number >= (minimum + (index2 * divide_date)):
                    if date_number <= (minimum + ((index2 + 1) * divide_date)):

                        if "d" + str(index + 1) in new_chain:
                            chain_set[index2] = "d" + str(index + 1)
        else:
            for index2 in range(num_chains):

                if date_number >= (minimum + (index2 * divide_date)):
                    if date_number <= (minimum + ((index2 + 1) * divide_date)):

                        if (index+1) == (num_articles+1):
                            chain_set[index2] = "s"
                        else:
                            chain_set[index2] = "t"

    final_chain = []
    for item in chain_set:
        if not item == '':
            final_chain.append(item)

    ap = (len(new_chain) / (len(new_chain) + (num_chains - len(final_chain))))
    Percent_AP = N(ap * 100, 4)

    ar = len(new_chain) / (len(new_chain) + len(final_chain))
    Percent_AR = N(ar * 100, 4)

    f1 = (2 * ap * ar) / (ap + ar)
    Percent_F1 = N(f1 * 100, 4)

    print('Percent_AP: ', Percent_AP)  # Average Precision
    print('Percent_AR: ', Percent_AR)  # Average Recall
    print('Percent_F1: ', Percent_F1)  # F1 Score
    print('final_chain: ', final_chain)
    print('new_chain: ', new_chain)









